/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.csv.results.IndexRemover;
import org.anchoranalysis.feature.io.csv.results.WriteLazy;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

class RemoveNaNColumns
extends WriteLazy {
    private List<Integer> indicesToCheck = new ArrayList<Integer>();

    public RemoveNaNColumns(FeatureCSVMetadataForOutput outputMetadata, FeatureCSVWriterFactory writerCreator, Optional<Consumer<LabelledResultsVector>> consumeAfterAdding) throws OutputWriteFailedException {
        super(outputMetadata, writerCreator, consumeAfterAdding);
        int numberFeatures = outputMetadata.featureNames().size();
        this.indicesToCheck = IntStream.range(0, numberFeatures).boxed().collect(Collectors.toList());
    }

    @Override
    public void add(LabelledResultsVector results) {
        super.add(results);
        Iterator<Integer> iterator = this.indicesToCheck.iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            if (Double.isNaN(results.get(index))) continue;
            iterator.remove();
        }
    }

    @Override
    protected FeatureCSVMetadata processBeforeWriting(FeatureCSVMetadataForOutput metadata, List<LabelledResultsVector> results) {
        IndexRemover.removeResultsAtIndices(results, this.indicesToCheck);
        FeatureNameList namesKept = IndexRemover.removeHeadersAtIndices(metadata.featureNames(), this.indicesToCheck);
        return new FeatureCSVMetadata(metadata.outputName(), metadata.nonFeatureHeaders(), namesKept);
    }
}

