/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.results;

import java.util.Optional;
import java.util.function.Consumer;
import org.anchoranalysis.feature.io.csv.FeatureCSVWriter;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriter;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

class WriteEager
extends LabelledResultsCSVWriter {
    private Optional<FeatureCSVWriter> singleWriter = Optional.empty();

    protected WriteEager(FeatureCSVMetadataForOutput outputMetadata, FeatureCSVWriterFactory writerCreator, Optional<Consumer<LabelledResultsVector>> consumeAfterAdding) {
        super(outputMetadata, writerCreator, consumeAfterAdding);
    }

    @Override
    public void start() throws OutputWriteFailedException {
        this.singleWriter = this.createWriter(this.outputMetadata.metadata());
    }

    @Override
    public void add(LabelledResultsVector results) {
        this.maybeConsumeResults(results);
        if (this.singleWriter.isPresent()) {
            this.singleWriter.get().addRow(results);
        }
    }

    @Override
    public void end() {
        this.singleWriter.ifPresent(FeatureCSVWriter::close);
    }
}

