/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.results;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.anchoranalysis.feature.io.csv.FeatureCSVWriter;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriter;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

abstract class WriteLazy
extends LabelledResultsCSVWriter {
    private List<LabelledResultsVector> storedResults;

    protected WriteLazy(FeatureCSVMetadataForOutput outputMetadata, FeatureCSVWriterFactory writerCreator, Optional<Consumer<LabelledResultsVector>> consumeAfterAdding) {
        super(outputMetadata, writerCreator, consumeAfterAdding);
    }

    @Override
    public void start() {
        this.storedResults = new ArrayList<LabelledResultsVector>();
    }

    @Override
    public void add(LabelledResultsVector results) {
        this.storedResults.add(results);
    }

    @Override
    public void end() throws OutputWriteFailedException {
        FeatureCSVMetadata csvMetadata = this.processBeforeWriting(this.outputMetadata, this.storedResults);
        Optional<FeatureCSVWriter> singleWriter = this.createWriter(csvMetadata);
        for (LabelledResultsVector results : this.storedResults) {
            this.maybeConsumeResults(results);
            if (!singleWriter.isPresent()) continue;
            singleWriter.get().addRow(results);
        }
        singleWriter.ifPresent(FeatureCSVWriter::close);
        this.storedResults.clear();
    }

    protected abstract FeatureCSVMetadata processBeforeWriting(FeatureCSVMetadataForOutput var1, List<LabelledResultsVector> var2);
}

