/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.table;

import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.csv.table.FeatureTableCSVGenerator;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.results.ResultsVectorList;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

class VerticalValues
extends FeatureTableCSVGenerator<ResultsVectorList> {
    public VerticalValues(FeatureNameList featureNames) {
        super(featureNames.asList());
    }

    @Override
    protected void writeFeaturesToCSV(CSVWriter writer, ResultsVectorList allFeatureResults, List<String> headerNames) throws OutputWriteFailedException {
        int size = headerNames.size();
        for (int featureIndex = 0; featureIndex < size; ++featureIndex) {
            String featureName = headerNames.get(featureIndex);
            writer.writeRow(VerticalValues.generateRow(featureName, allFeatureResults, featureIndex, size));
        }
    }

    private static List<TypedValue> generateRow(String featureName, ResultsVectorList allFeatureResults, int featureIndex, int size) throws OutputWriteFailedException {
        ArrayList<TypedValue> csvRow = new ArrayList<TypedValue>(allFeatureResults.size());
        csvRow.add(new TypedValue(featureName));
        for (ResultsVector results : allFeatureResults) {
            if (results.size() != size) {
                throw new OutputWriteFailedException(String.format("ResultsVector has size (%d) != featureNames vector (%d)", results.size(), size));
            }
            csvRow.add(VerticalValues.replaceNaN(results.get(featureIndex)));
        }
        return csvRow;
    }

    private static TypedValue replaceNaN(double val) {
        if (Double.isNaN(val)) {
            return new TypedValue("Error");
        }
        return new TypedValue(val, 10);
    }
}

