/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.results;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;

public class FeatureOutputNames {
    public static final String OUTPUT_DEFAULT_NON_AGGREGATED = "features";
    public static final String OUTPUT_SUFFIX_AGGREGATED = "Aggregated";
    public static final String OUTPUT_SUFFIX_GROUP = "Group";
    public static final String OUTPUT_SUFFIX_AGGREGATED_GROUP = "AggregatedGroup";
    private String csvFeaturesNonAggregated;
    private Optional<String> csvFeaturesAggregated;
    private Optional<String> csvFeaturesGroup;
    private Optional<String> xmlAggregatedGroup;

    public FeatureOutputNames() {
        this(OUTPUT_DEFAULT_NON_AGGREGATED, true, true);
    }

    public FeatureOutputNames(String prefix, boolean enableAggregated, boolean enableGroup) {
        this.csvFeaturesNonAggregated = prefix;
        this.csvFeaturesAggregated = FeatureOutputNames.joinIfEnabled(enableAggregated, prefix, OUTPUT_SUFFIX_AGGREGATED);
        this.csvFeaturesGroup = FeatureOutputNames.joinIfEnabled(enableGroup, prefix, OUTPUT_SUFFIX_GROUP);
        this.xmlAggregatedGroup = FeatureOutputNames.joinIfEnabled(enableGroup, prefix, OUTPUT_SUFFIX_AGGREGATED_GROUP);
    }

    public boolean calculationResultsNeeded(MultiLevelOutputEnabled outputEnabled) {
        if (outputEnabled.isOutputEnabled(this.csvFeaturesNonAggregated)) {
            return true;
        }
        if (FeatureOutputNames.outputPresentAndEnabled(this.csvFeaturesAggregated, outputEnabled)) {
            return true;
        }
        if (FeatureOutputNames.outputPresentAndEnabled(this.csvFeaturesGroup, outputEnabled)) {
            return true;
        }
        return FeatureOutputNames.outputPresentAndEnabled(this.xmlAggregatedGroup, outputEnabled);
    }

    private static boolean outputPresentAndEnabled(Optional<String> outputName, MultiLevelOutputEnabled outputEnabled) {
        return outputName.isPresent() && outputEnabled.isOutputEnabled(outputName.get());
    }

    private static Optional<String> joinIfEnabled(boolean enabled, String prefix, String suffix) {
        return OptionalFactory.create((boolean)enabled, () -> prefix + suffix);
    }

    @Generated
    public String getCsvFeaturesNonAggregated() {
        return this.csvFeaturesNonAggregated;
    }

    @Generated
    public Optional<String> getCsvFeaturesAggregated() {
        return this.csvFeaturesAggregated;
    }

    @Generated
    public Optional<String> getCsvFeaturesGroup() {
        return this.csvFeaturesGroup;
    }

    @Generated
    public Optional<String> getXmlAggregatedGroup() {
        return this.xmlAggregatedGroup;
    }
}

