/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.results.group;

import java.util.Optional;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriter;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriterFactory;
import org.anchoranalysis.feature.io.name.MultiName;
import org.anchoranalysis.feature.io.results.FeatureOutputMetadata;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.io.results.group.ResultsMap;
import org.anchoranalysis.feature.io.results.group.WriteAggregatedForGroup;
import org.anchoranalysis.feature.io.results.group.WriteCSVForGroup;
import org.anchoranalysis.feature.results.ResultsVectorList;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContextSubdirectoryCache;

public class GroupedResults {
    private ResultsMap map = new ResultsMap();

    public void addResultsFor(LabelledResultsVector results) {
        this.map.addResultsFor(results);
    }

    public void writeGroupResults(Optional<NamedFeatureStore<FeatureInputResults>> featuresAggregate, boolean includeGroups, FeatureOutputMetadata outputMetadata, FeatureCSVWriterFactory createAggregatedCSVWriter, InputOutputContextSubdirectoryCache contextGroups) throws OutputWriteFailedException {
        if (includeGroups) {
            this.writeGroupXMLAndIntoCSV(outputMetadata, contextGroups);
        }
        if (featuresAggregate.isPresent()) {
            this.writeAggregated(featuresAggregate.get(), outputMetadata, createAggregatedCSVWriter, contextGroups);
        }
    }

    private void writeGroupXMLAndIntoCSV(FeatureOutputMetadata outputMetadata, InputOutputContextSubdirectoryCache contextGroups) {
        outputMetadata.outputNames().getCsvFeaturesGroup().ifPresent(outputName -> {
            WriteCSVForGroup groupedCSVWriter = new WriteCSVForGroup((String)outputName, outputMetadata.featureNamesNonAggregated(), contextGroups);
            this.map.iterateResults(groupedCSVWriter::write);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAggregated(NamedFeatureStore<FeatureInputResults> featuresAggregate, FeatureOutputMetadata outputMetadata, FeatureCSVWriterFactory aggregatedCSVWriterCreator, InputOutputContextSubdirectoryCache contextGroups) throws OutputWriteFailedException {
        if (this.map.isEmpty()) {
            return;
        }
        Optional<FeatureCSVMetadataForOutput> metadataAggregated = outputMetadata.csvAggregated(featuresAggregate.featureNames());
        if (!metadataAggregated.isPresent()) {
            return;
        }
        LabelledResultsCSVWriter aggregatedResults = LabelledResultsCSVWriterFactory.create(metadataAggregated.get(), aggregatedCSVWriterCreator, Optional.empty(), true);
        aggregatedResults.start();
        try {
            this.map.iterateResults((groupName, results) -> {
                if (!results.isEmpty()) {
                    new WriteAggregatedForGroup(featuresAggregate, (ResultsVectorList)results).maybeWrite((Optional<MultiName>)groupName, outputMetadata, Optional.of(aggregatedResults), contextGroups);
                }
            });
        }
        finally {
            aggregatedResults.end();
        }
    }
}

