/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.results.group;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.friendly.HasFriendlyErrorMessage;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriter;
import org.anchoranalysis.feature.io.name.MultiName;
import org.anchoranalysis.feature.io.results.FeatureOutputMetadata;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.results.ResultsVectorList;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.InputOutputContextSubdirectoryCache;

class WriteAggregatedForGroup {
    private NamedFeatureStore<FeatureInputResults> featuresAggregate;
    private ResultsVectorList results;

    public void maybeWrite(Optional<MultiName> groupName, FeatureOutputMetadata metadata, Optional<LabelledResultsCSVWriter> aggegrateResults, InputOutputContextSubdirectoryCache context) throws OutputWriteFailedException {
        OptionalUtilities.ifPresent(metadata.outputNames().getXmlAggregatedGroup(), outputName -> this.maybeWriteForOutput((String)outputName, groupName, metadata.featureNamesNonAggregated(), aggegrateResults, context.get(groupName.map(MultiName::toString))));
    }

    private void maybeWriteForOutput(String outputName, Optional<MultiName> groupName, FeatureNameList featureNames, Optional<LabelledResultsCSVWriter> aggregateResults, InputOutputContext contextGroup) throws OutputWriteFailedException {
        if (aggregateResults.isPresent() || groupName.isPresent()) {
            ResultsVector aggregated = this.aggregateResults(featureNames, contextGroup.getLogger());
            if (groupName.isPresent()) {
                WriteAggregatedForGroup.writeAggregatedAsParameters(outputName, this.featuresAggregate, aggregated, contextGroup);
            }
            aggregateResults.ifPresent(writer -> writer.add(new LabelledResultsVector(groupName, aggregated)));
        }
    }

    private ResultsVector aggregateResults(FeatureNameList featureNames, Logger logger) throws OutputWriteFailedException {
        FeatureCalculatorMulti calculator;
        try {
            calculator = FeatureSession.with((FeatureList)this.featuresAggregate.features(), (Logger)logger);
        }
        catch (InitializeException e1) {
            logger.errorReporter().recordError(WriteAggregatedForGroup.class, (Throwable)e1);
            throw new OutputWriteFailedException("Cannot start feature-session", (HasFriendlyErrorMessage)e1);
        }
        FeatureInputResults input = new FeatureInputResults(this.results, featureNames.createMapToIndex());
        return calculator.calculateSuppressErrors((FeatureInput)input, logger.errorReporter());
    }

    private static <T extends FeatureInput> void writeAggregatedAsParameters(String outputName, NamedFeatureStore<T> featuresAggregate, ResultsVector results, InputOutputContext context) {
        Dictionary dictionary = new Dictionary();
        for (int i = 0; i < featuresAggregate.size(); ++i) {
            NamedBean item = featuresAggregate.get(i);
            double val = results.get(i);
            dictionary.put(item.getName(), Double.toString(val));
        }
        try {
            Optional fileOutPath = context.getOutputter().writerSelective().createFilenameForWriting(outputName, NonImageFileFormat.XML.extensionWithoutPeriod());
            if (fileOutPath.isPresent()) {
                dictionary.writeToFile((Path)fileOutPath.get());
            }
        }
        catch (IOException e) {
            context.getLogger().errorReporter().recordError(WriteAggregatedForGroup.class, (Throwable)e);
        }
    }

    @Generated
    public WriteAggregatedForGroup(NamedFeatureStore<FeatureInputResults> featuresAggregate, ResultsVectorList results) {
        this.featuresAggregate = featuresAggregate;
        this.results = results;
    }
}

