/*-
 * #%L
 * anchor-feature-session
 * %%
 * Copyright (C) 2010 - 2020 Owen Feehan, ETH Zurich, University of Zurich, Hoffmann-La Roche
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

package org.anchoranalysis.feature.session.cache.finder;

import java.util.Optional;
import java.util.Set;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.input.FeatureInput;

/**
 * The default strategy for finding children by always directly taking (or creating a child-cache)
 * as necessary.
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class DefaultChildCacheFinder implements ChildCacheFinder {

    /** Singleton instance of {@link DefaultChildCacheFinder}. */
    private static final ChildCacheFinder INSTANCE = new DefaultChildCacheFinder();

    @Override
    public <V extends FeatureInput> FeatureCalculationCache<V> childCacheFor(
            FeatureCalculationCache<?> parentCache,
            CacheCreator factory,
            ChildCacheName childName,
            V input) {
        return parentCache.childCacheFor(childName, input.getClass(), factory);
    }

    @Override
    public ChildCacheFinder finderForGrandchild() {
        return INSTANCE;
    }

    /**
     * Singleton instance of {@link DefaultChildCacheFinder}.
     *
     * @return the singleton instance.
     */
    public static ChildCacheFinder instance() {
        return INSTANCE;
    }

    @Override
    public Optional<Set<ChildCacheName>> cachesToAvoidInvalidating() {
        return Optional.empty();
    }
}
