/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session;

import java.util.Optional;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingleFromMulti;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.SequentialSession;
import org.anchoranalysis.feature.session.replace.BoundReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReuseSingletonStrategy;
import org.anchoranalysis.feature.shared.SharedFeatures;

public class FeatureSession {
    public static <T extends FeatureInput> FeatureCalculatorSingle<T> with(Feature<T> feature, Logger logger) throws InitializeException {
        return FeatureSession.with(feature, new FeatureInitialization(), new SharedFeatures(), logger);
    }

    public static <T extends FeatureInput> FeatureCalculatorSingle<T> with(Feature<T> feature, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        return FeatureSession.with(feature, new FeatureInitialization(), sharedFeatures, logger);
    }

    public static <T extends FeatureInput> FeatureCalculatorSingle<T> with(Feature<T> feature, FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        SequentialSession<T> session = new SequentialSession<T>(feature);
        FeatureSession.startSession(session, initialization, sharedFeatures, logger);
        return new FeatureCalculatorSingleFromMulti(session);
    }

    public static <T extends FeatureInput> FeatureCalculatorMulti<T> with(FeatureList<T> features, Logger logger) throws InitializeException {
        return FeatureSession.with(features, new FeatureInitialization(), new SharedFeatures(), logger);
    }

    public static <T extends FeatureInput> FeatureCalculatorMulti<T> with(FeatureList<T> features, FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        return FeatureSession.with(features, initialization, Optional.of(sharedFeatures), logger, new BoundReplaceStrategy(ReuseSingletonStrategy::new));
    }

    public static <T extends FeatureInput> FeatureCalculatorMulti<T> with(FeatureList<T> features, FeatureInitialization initialization, Optional<SharedFeatures> sharedFeatures, Logger logger, BoundReplaceStrategy<T, ? extends ReplaceStrategy<T>> replaceStrategy) throws InitializeException {
        SequentialSession<T> session = new SequentialSession<T>(features, replaceStrategy);
        FeatureSession.startSession(session, initialization, sharedFeatures.orElse(new SharedFeatures()), logger);
        return session;
    }

    public static <T extends FeatureInput> double calculateWith(Feature<T> feature, T input, Logger logger) throws FeatureCalculationException {
        try {
            FeatureCalculatorSingle<T> calculator = FeatureSession.with(feature, logger);
            return calculator.calculate(input);
        }
        catch (InitializeException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private static <T extends FeatureInput> void startSession(SequentialSession<T> session, FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        try {
            session.start(initialization, sharedFeatures, logger);
        }
        catch (InitializeException e) {
            throw new InitializeException("An error occurred starting the feature (sequential) session", (Throwable)e);
        }
    }

    private FeatureSession() {
    }
}

