/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session;

import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.replace.BoundReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReuseSingletonStrategy;
import org.anchoranalysis.feature.shared.SharedFeatures;

public class SequentialSession<T extends FeatureInput>
implements FeatureCalculatorMulti<T> {
    private static final String ERROR_NOT_STARTED = "Session has not been started yet. Call start().";
    private FeatureList<T> listFeatures;
    private boolean isStarted = false;
    private boolean reportErrors = false;
    private ReplaceStrategy<T> replaceStrategy;
    private BoundReplaceStrategy<T, ? extends ReplaceStrategy<T>> replacePolicyFactory;

    SequentialSession(Feature<T> feature) {
        this((Iterable<Feature<T>>)FeatureListFactory.from((Feature[])new Feature[]{feature}));
    }

    SequentialSession(Iterable<Feature<T>> features) {
        this(features, new BoundReplaceStrategy(ReuseSingletonStrategy::new));
    }

    SequentialSession(Iterable<Feature<T>> features, BoundReplaceStrategy<T, ? extends ReplaceStrategy<T>> replacePolicyFactory) {
        this.replacePolicyFactory = replacePolicyFactory;
        this.listFeatures = FeatureListFactory.fromIterable(features);
    }

    public void start(FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        if (this.isStarted) {
            throw new InitializeException("Session has already been started.");
        }
        this.checkNoIntersectionWithSharedFeatures(sharedFeatures);
        this.setupCacheAndInit(initialization, sharedFeatures, logger);
        this.isStarted = true;
    }

    public ResultsVector calculate(T input) throws NamedFeatureCalculateException {
        this.checkIsStarted();
        return this.calculateThrowException(input);
    }

    public ResultsVector calculate(T input, FeatureList<T> featuresSubset) throws NamedFeatureCalculateException {
        this.checkIsStarted();
        try {
            return this.replaceStrategy.createOrReuse(input).calculate(featuresSubset);
        }
        catch (Exception e) {
            throw new NamedFeatureCalculateException(e);
        }
    }

    public ResultsVector calculateSuppressErrors(T input, ErrorReporter errorReporter) {
        ResultsVector results = new ResultsVector(this.listFeatures.size());
        if (!this.isStarted) {
            errorReporter.recordError(SequentialSession.class, ERROR_NOT_STARTED);
            results.setErrorAll((Exception)((Object)new OperationFailedException(ERROR_NOT_STARTED)));
        } else {
            this.calculateCommonSuppressErrors(results, input, errorReporter);
        }
        return results;
    }

    public int sizeFeatures() {
        return this.listFeatures.size();
    }

    private void calculateCommonSuppressErrors(ResultsVector results, T input, ErrorReporter errorReporter) {
        FeatureCalculationInput<T> sessionInput;
        try {
            sessionInput = this.replaceStrategy.createOrReuse(input);
        }
        catch (Exception e) {
            if (this.reportErrors) {
                errorReporter.recordError(SequentialSession.class, (Throwable)e);
            }
            for (int i = 0; i < this.listFeatures.size(); ++i) {
                results.setError(i, e);
            }
            return;
        }
        for (int i = 0; i < this.listFeatures.size(); ++i) {
            Feature f = this.listFeatures.get(i);
            try {
                results.set(i, sessionInput.calculate(f));
                continue;
            }
            catch (Exception e) {
                if (this.reportErrors) {
                    errorReporter.recordError(SequentialSession.class, (Throwable)e);
                }
                results.setError(i, e);
            }
        }
    }

    private ResultsVector calculateThrowException(T input) throws NamedFeatureCalculateException {
        FeatureCalculationInput<T> sessionInput;
        try {
            sessionInput = this.replaceStrategy.createOrReuse(input);
        }
        catch (OperationFailedException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
        ResultsVector results = new ResultsVector(this.listFeatures.size());
        for (int i = 0; i < this.listFeatures.size(); ++i) {
            Feature feature = this.listFeatures.get(i);
            try {
                double val = sessionInput.calculate(feature);
                results.set(i, val);
                continue;
            }
            catch (Exception e) {
                throw new NamedFeatureCalculateException(feature.getFriendlyName(), e.getMessage());
            }
        }
        return results;
    }

    private void checkNoIntersectionWithSharedFeatures(SharedFeatures sharedFeatures) throws InitializeException {
        assert (this.listFeatures != null);
        try {
            for (Feature f : this.listFeatures) {
                FeatureList allDependents = f.createListChildFeatures();
                for (Feature dep : allDependents) {
                    if (!sharedFeatures.contains(dep)) continue;
                    throw new InitializeException(String.format("Feature '%s' is found in both the session and in the SharedFeatures", dep.getFriendlyName()));
                }
            }
        }
        catch (BeanMisconfiguredException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    private void setupCacheAndInit(FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) throws InitializeException {
        assert (initialization != null);
        FeatureInitialization initializationDup = initialization.duplicateShallow();
        this.listFeatures.initializeRecursive(initializationDup, logger);
        this.replaceStrategy = this.replacePolicyFactory.createOrReuse(this.listFeatures, initializationDup, sharedFeatures, logger);
    }

    private void checkIsStarted() throws NamedFeatureCalculateException {
        if (!this.isStarted) {
            throw new NamedFeatureCalculateException(ERROR_NOT_STARTED);
        }
    }
}

