/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.FeatureCalculator;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.CalculateForChild;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.calculate.cache.FeatureSymbolCalculator;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.cache.finder.ChildCacheFinder;
import org.anchoranalysis.feature.session.cache.finder.DefaultChildCacheFinder;

public class SessionInputSequential<T extends FeatureInput>
implements FeatureCalculationInput<T> {
    private FeatureCalculationCache<T> cache;
    private T input;
    private CacheCreator cacheCreator;
    private ChildCalculator childCalc;
    private ChildCacheFinder findChild;

    public SessionInputSequential(T input, CacheCreator cacheCreator) {
        this.input = input;
        this.cacheCreator = cacheCreator;
        this.cache = cacheCreator.create(input.getClass());
        this.childCalc = new ChildCalculator(DefaultChildCacheFinder.instance());
    }

    public SessionInputSequential(T input, CacheCreator cacheCreator, ChildCacheFinder findChild) {
        this.input = input;
        this.cacheCreator = cacheCreator;
        this.cache = cacheCreator.create(input.getClass());
        this.childCalc = new ChildCalculator(findChild);
        this.findChild = findChild;
    }

    SessionInputSequential(T input, FeatureCalculationCache<T> cache, CacheCreator cacheFactory, ChildCacheFinder findChild) {
        this.input = input;
        this.cacheCreator = cacheFactory;
        this.cache = cache;
        this.childCalc = new ChildCalculator(findChild);
    }

    public void replaceInput(T input) {
        Optional<Set<ChildCacheName>> exceptedChildren = this.findChild.cachesToAvoidInvalidating();
        if (exceptedChildren.isPresent()) {
            this.cache.invalidateExcept(exceptedChildren.get());
        } else {
            this.cache.invalidate();
        }
        this.input = input;
    }

    public T get() {
        return this.input;
    }

    public double calculate(Feature<T> feature) throws FeatureCalculationException {
        return this.cache.calculator().calculate(feature, (FeatureCalculationInput)this);
    }

    public ResultsVector calculate(FeatureList<T> features) throws NamedFeatureCalculateException {
        return this.cache.calculator().calculate(features, (FeatureCalculationInput)this);
    }

    public <S> S calculate(CalculationPart<S, T> cc) throws FeatureCalculationException {
        return (S)this.resolver().search(cc).getOrCalculate(this.input);
    }

    public <S> S calculate(ResolvedPart<S, T> calculation) throws FeatureCalculationException {
        return (S)calculation.getOrCalculate(this.input);
    }

    public CalculationPartResolver<T> resolver() {
        return this.cache.calculator();
    }

    public FeatureSymbolCalculator<T> bySymbol() {
        return this.cache.calculator();
    }

    public CalculateForChild<T> forChild() {
        return this.childCalc;
    }

    public FeatureCalculationCache<T> getCache() {
        return this.cache;
    }

    private class ChildCalculator
    implements CalculateForChild<T> {
        private ChildCacheFinder findChild;

        public <S extends FeatureInput> double calculate(Feature<S> feature, CalculationPart<S, T> calculation, ChildCacheName childCacheName) throws FeatureCalculationException {
            return this.calculate(feature, (FeatureInput)SessionInputSequential.this.calculate(calculation), childCacheName);
        }

        public <S extends FeatureInput> double calculate(Feature<S> feature, S input, ChildCacheName childCacheName) throws FeatureCalculationException {
            FeatureCalculationCache<S> child = this.childCacheFor(childCacheName, input);
            return child.calculator().calculate(feature, new SessionInputSequential<S>(input, child, SessionInputSequential.this.cacheCreator, this.findChild.finderForGrandchild()));
        }

        public <V extends FeatureInput, U> U calculate(ChildCacheName childCacheName, V input, Function<CalculationPartResolver<V>, ResolvedPart<U, V>> funcCalc) throws FeatureCalculationException {
            FeatureCalculator childResolver = this.childCacheFor(childCacheName, input).calculator();
            ResolvedPart<U, V> resolvedCalc = funcCalc.apply((CalculationPartResolver<V>)childResolver);
            return (U)resolvedCalc.getOrCalculate(input);
        }

        private <V extends FeatureInput> FeatureCalculationCache<V> childCacheFor(ChildCacheName childName, V input) throws FeatureCalculationException {
            return this.findChild.childCacheFor(SessionInputSequential.this.cache, SessionInputSequential.this.cacheCreator, childName, input);
        }

        public ChildCalculator(ChildCacheFinder findChild) {
            this.findChild = findChild;
        }
    }
}

