/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.FeatureCalculator;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.ResettableCalculator;
import org.anchoranalysis.feature.shared.SharedFeaturesSubset;

class CalculationCache<T extends FeatureInput>
implements FeatureCalculationCache<T> {
    private ResettableCalculator<T> calculator;
    private SharedFeaturesSubset<T> sharedFeatures;
    private Map<ChildCacheName, FeatureCalculationCache<? extends FeatureInput>> children = new HashMap<ChildCacheName, FeatureCalculationCache<? extends FeatureInput>>();

    public CalculationCache(SharedFeaturesSubset<T> sharedFeatures) {
        this.sharedFeatures = sharedFeatures;
        this.calculator = new ResettableCalculator<T>(sharedFeatures);
    }

    public void initialize(FeatureInitialization initialization, Logger logger) {
    }

    public void invalidate() {
        this.calculator.invalidate();
        for (FeatureCalculationCache<? extends FeatureInput> childCache : this.children.values()) {
            childCache.invalidate();
        }
    }

    public void invalidateExcept(Set<ChildCacheName> childCacheNames) {
        this.calculator.invalidate();
        for (Map.Entry<ChildCacheName, FeatureCalculationCache<? extends FeatureInput>> entry : this.children.entrySet()) {
            if (childCacheNames.contains(entry.getKey())) continue;
            entry.getValue().invalidate();
        }
    }

    public FeatureCalculator<T> calculator() {
        return this.calculator;
    }

    public <V extends FeatureInput> FeatureCalculationCache<V> childCacheFor(ChildCacheName childName, Class<? extends FeatureInput> inputType, CacheCreator cacheCreator) {
        return this.children.computeIfAbsent(childName, s -> cacheCreator.create(inputType));
    }
}

