/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.Collection;
import java.util.Set;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.FeatureCalculator;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.FeatureResultMap;
import org.anchoranalysis.feature.session.cache.HorizontalFeatureCalculator;
import org.anchoranalysis.feature.shared.SharedFeaturesSubset;

class FeatureCache<T extends FeatureInput>
implements FeatureCalculationCache<T> {
    private FeatureCalculationCache<T> cache;
    private HorizontalFeatureCalculator<T> calculator;
    private FeatureResultMap<T> map = new FeatureResultMap();

    public FeatureCache(FeatureCalculationCache<T> cache, FeatureList<T> namedFeatures, SharedFeaturesSubset<T> sharedFeatures, Collection<String> ignorePrefixes) {
        this.cache = cache;
        namedFeatures.forEach(this.map::add);
        sharedFeatures.forEach(this.map::add);
        this.calculator = new HorizontalFeatureCalculator<T>(cache.calculator(), this.map, ignorePrefixes);
    }

    public void initialize(FeatureInitialization initialization, Logger logger) {
        this.cache.initialize(initialization, logger);
    }

    public void invalidate() {
        this.map.clear();
        this.cache.invalidate();
    }

    public void invalidateExcept(Set<ChildCacheName> childCacheNames) {
        this.map.clear();
        this.cache.invalidateExcept(childCacheNames);
    }

    public <V extends FeatureInput> FeatureCalculationCache<V> childCacheFor(ChildCacheName childName, Class<? extends FeatureInput> inputType, CacheCreator cacheCreator) {
        return this.cache.childCacheFor(childName, inputType, cacheCreator);
    }

    public FeatureCalculator<T> calculator() {
        return this.calculator;
    }
}

