/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.HashMap;
import java.util.Map;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.input.FeatureInput;

class FeatureResultMap<T extends FeatureInput> {
    private Map<Feature<T>, Double> mapFeature = new HashMap<Feature<T>, Double>();
    private Map<String, Double> mapID = new HashMap<String, Double>();
    private Map<String, Feature<T>> mapFeatureName = new HashMap<String, Feature<T>>();

    FeatureResultMap() {
    }

    public void add(Feature<T> feature, String featureName, Double result) {
        this.mapFeature.put(feature, result);
        this.mapID.put(featureName, result);
    }

    public void add(Feature<T> feature) {
        String customName = feature.getCustomName();
        if (customName != null && !customName.isEmpty()) {
            this.mapFeatureName.put(customName, feature);
        }
    }

    public void clear() {
        this.mapFeature.clear();
        this.mapID.clear();
    }

    public Feature<T> getFeatureFor(String name) {
        return this.mapFeatureName.get(name);
    }

    public Double getResultFor(Feature<T> feature) {
        return this.mapFeature.get(feature);
    }

    public Double getResultFor(String name) {
        return this.mapID.get(name);
    }
}

