/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.ArrayList;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputType;
import org.anchoranalysis.feature.session.cache.CalculationCache;
import org.anchoranalysis.feature.session.cache.FeatureCache;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.feature.shared.SharedFeaturesSubset;

public class HorizontalCacheCreator
implements CacheCreator {
    private FeatureList<? extends FeatureInput> namedFeatures;
    private SharedFeatures sharedFeatures;
    private FeatureInitialization initialization;
    private Logger logger;

    public <T extends FeatureInput> FeatureCalculationCache<T> create(Class<? extends FeatureInput> inputType) {
        FeatureList<T> featureList = this.filterFeatureList(inputType);
        return this.createCache(featureList, inputType, this.initialization, this.logger);
    }

    private <T extends FeatureInput> FeatureList<T> filterFeatureList(Class<? extends FeatureInput> inputType) {
        return this.namedFeatures.filterAndMap(feature -> FeatureInputType.isCompatibleWith((Class)feature.inputType(), (Class)inputType), feature -> feature);
    }

    private <T extends FeatureInput> FeatureCalculationCache<T> createCache(FeatureList<T> namedFeatures, Class<? extends FeatureInput> inputType, FeatureInitialization initialization, Logger logger) {
        SharedFeaturesSubset sharedFeaturesSet = this.sharedFeatures.subsetCompatibleWith(inputType);
        try {
            sharedFeaturesSet.initializeRecursive(initialization, logger);
        }
        catch (InitializeException e) {
            logger.errorReporter().recordError(HorizontalCacheCreator.class, "An error occurred initializing shared-features, proceeding anyway.");
            logger.errorReporter().recordError(HorizontalCacheCreator.class, (Throwable)e);
        }
        FeatureCalculationCache<T> cache = HorizontalCacheCreator.createCache(namedFeatures, sharedFeaturesSet);
        cache.initialize(initialization, logger);
        return cache;
    }

    private static <S extends FeatureInput> FeatureCalculationCache<S> createCache(FeatureList<S> namedFeatures, SharedFeaturesSubset<S> sharedFeatures) {
        CalculationCache<S> cacheCalculation = new CalculationCache<S>(sharedFeatures);
        return new FeatureCache<S>(cacheCalculation, namedFeatures, sharedFeatures, new ArrayList<String>());
    }

    public HorizontalCacheCreator(FeatureList<? extends FeatureInput> namedFeatures, SharedFeatures sharedFeatures, FeatureInitialization initialization, Logger logger) {
        this.namedFeatures = namedFeatures;
        this.sharedFeatures = sharedFeatures;
        this.initialization = initialization;
        this.logger = logger;
    }
}

