/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.Collection;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.FeatureCalculator;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPartMap;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartMap;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.FeatureResultMap;

class HorizontalFeatureCalculator<T extends FeatureInput>
implements FeatureCalculator<T> {
    private FeatureCalculator<T> delegate;
    private FeatureResultMap<T> map;
    private Collection<String> ignorePrefixes;

    public double calculate(Feature<T> feature, FeatureCalculationInput<T> input) throws FeatureCalculationException {
        if (feature.getCustomName() == null || feature.getCustomName().isEmpty()) {
            return this.delegate.calculate(feature, input);
        }
        Double result = this.map.getResultFor(feature);
        if (result == null) {
            result = this.calculateAndAdd(feature, input);
        }
        return result;
    }

    public <U> ResolvedPart<U, T> search(CalculationPart<U, T> cc) {
        return this.delegate.search(cc);
    }

    public <S, U> ResolvedPartMap<S, T, U> search(CalculationPartMap<S, T, U, FeatureCalculationException> cc) {
        return this.delegate.search(cc);
    }

    public String resolveFeatureIdentifier(String identifier) {
        for (String prefix : this.ignorePrefixes) {
            if (!identifier.startsWith(prefix)) continue;
            String idPrefixRemoved = identifier.substring(prefix.length());
            return this.delegate.resolveFeatureIdentifier(idPrefixRemoved);
        }
        return this.delegate.resolveFeatureIdentifier(identifier);
    }

    public double calculateFeatureByIdentifier(String id, FeatureCalculationInput<T> input) throws FeatureCalculationException {
        Double result = this.map.getResultFor(id);
        if (result != null) {
            return result;
        }
        Feature<T> feature = this.map.getFeatureFor(id);
        if (feature != null) {
            return this.calculateAndAdd(feature, input);
        }
        return this.delegate.calculateFeatureByIdentifier(id, input);
    }

    private Double calculateAndAdd(Feature<T> feature, FeatureCalculationInput<T> input) throws FeatureCalculationException {
        Double result = this.delegate.calculate(feature, input);
        this.map.add(feature, this.resolveNameFeature(feature), result);
        return result;
    }

    private String resolveNameFeature(Feature<T> feature) {
        String id = feature.getCustomName();
        if (id != null && !id.isEmpty()) {
            return this.resolveFeatureIdentifier(id);
        }
        return id;
    }

    public HorizontalFeatureCalculator(FeatureCalculator<T> delegate, FeatureResultMap<T> map, Collection<String> ignorePrefixes) {
        this.delegate = delegate;
        this.map = map;
        this.ignorePrefixes = ignorePrefixes;
    }
}

