/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.FeatureCalculator;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPartMap;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartMap;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.ResettableSet;
import org.anchoranalysis.feature.shared.SharedFeaturesSubset;

class ResettableCalculator<T extends FeatureInput>
implements FeatureCalculator<T> {
    private final SharedFeaturesSubset<T> sharedFeatures;
    private ResettableSet<CalculationPart<?, T>> setCalculation = new ResettableSet(false);
    private ResettableSet<CalculationPartMap<?, T, ?, FeatureCalculationException>> setCalculationMap = new ResettableSet(false);

    public void invalidate() {
        this.setCalculation.invalidate();
        this.setCalculationMap.invalidate();
    }

    public double calculate(Feature<T> feature, FeatureCalculationInput<T> input) throws FeatureCalculationException {
        return feature.calculateCheckInitialized(input);
    }

    public <U> ResolvedPart<U, T> search(CalculationPart<U, T> calculation) {
        return new ResolvedPart(this.setCalculation.findOrAdd(calculation, null));
    }

    public <S, U> ResolvedPartMap<S, T, U> search(CalculationPartMap<S, T, U, FeatureCalculationException> calculation) {
        return new ResolvedPartMap(this.setCalculationMap.findOrAdd(calculation, null));
    }

    public double calculateFeatureByIdentifier(String id, FeatureCalculationInput<T> input) throws FeatureCalculationException {
        try {
            Feature feature = this.sharedFeatures.getException(id);
            return this.calculate(feature, input);
        }
        catch (NamedProviderGetException e) {
            throw new FeatureCalculationException(String.format("Cannot locate feature with resolved-ID: %s", id), e.summarize());
        }
    }

    public String resolveFeatureIdentifier(String identifier) {
        return identifier;
    }

    public ResettableCalculator(SharedFeaturesSubset<T> sharedFeatures) {
        this.sharedFeatures = sharedFeatures;
    }
}

