/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache;

import java.util.HashMap;
import java.util.Map;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.cache.ResettableCalculation;

class ResettableSet<T extends ResettableCalculation> {
    private Map<T, T> map = new HashMap<T, T>();
    private boolean doLogging = false;

    public ResettableSet(boolean doLogging) {
        this.doLogging = doLogging;
    }

    public T findOrAdd(T target, Logger logger) {
        ResettableCalculation existing = (ResettableCalculation)this.map.get(target);
        if (existing == null) {
            if (this.doLogging && logger != null) {
                logger.messageLogger().logFormatted("Cache-addding: %s (%d)", new Object[]{target, target.hashCode()});
            }
            this.map.put(target, target);
            return target;
        }
        if (this.doLogging && logger != null) {
            logger.messageLogger().logFormatted("Cache-reusing: %s (%d)", new Object[]{existing, existing.hashCode()});
        }
        return (T)existing;
    }

    public void invalidate() {
        for (ResettableCalculation cachedCalculation : this.map.values()) {
            cachedCalculation.invalidate();
        }
    }

    public int size() {
        return this.map.size();
    }

    public String describe() {
        StringBuilder sb = new StringBuilder();
        for (ResettableCalculation item : this.map.values()) {
            sb.append(String.format("%s: %s%n", System.identityHashCode(item), item.toString()));
        }
        return sb.toString();
    }

    public String toString() {
        return this.describe();
    }
}

