/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache.finder;

import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.cache.LRUCache;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.finder.CacheSupplier;

public class CacheTransferSource<T extends FeatureInput> {
    private final CacheSupplier<T, OperationFailedException> cacheToSearch;
    private final Set<ChildCacheName> specificChildren;

    public boolean containsChild(ChildCacheName name) {
        return this.specificChildren.contains(name);
    }

    public Optional<FeatureCalculationInput<T>> getInputIfPresent(T input) throws OperationFailedException {
        Optional<LRUCache<LRUCache, FeatureCalculationInput<LRUCache>>> cache = this.cacheToSearch.get();
        return cache.flatMap(cacheInternal -> cacheInternal.getIfPresent(input));
    }

    public Set<ChildCacheName> getCacheNames() {
        return this.specificChildren;
    }

    public CacheTransferSource(CacheSupplier<T, OperationFailedException> cacheToSearch, Set<ChildCacheName> specificChildren) {
        this.cacheToSearch = cacheToSearch;
        this.specificChildren = specificChildren;
    }
}

