/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.cache.finder;

import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.FeatureCalculationCache;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.finder.CacheTransferSource;
import org.anchoranalysis.feature.session.cache.finder.CacheTransferSourceCollection;
import org.anchoranalysis.feature.session.cache.finder.ChildCacheFinder;
import org.anchoranalysis.feature.session.cache.finder.DefaultChildCacheFinder;
import org.anchoranalysis.feature.session.replace.CacheAndReuseStrategy;

public class CheckCacheForSpecificChildren
implements ChildCacheFinder {
    private final Class<?> cacheInputType;
    private final CacheTransferSourceCollection source;
    private CacheAndReuseStrategy<FeatureInput> fallbackCache = null;

    @Override
    public <V extends FeatureInput> FeatureCalculationCache<V> childCacheFor(FeatureCalculationCache<?> parentCache, CacheCreator factory, ChildCacheName childName, V input) throws FeatureCalculationException {
        if (this.cacheInputType.isAssignableFrom(input.getClass()) && this.source.contains(childName)) {
            return this.useSessionFromSource(childName, input, factory);
        }
        return parentCache.childCacheFor(childName, input.getClass(), factory);
    }

    private <V extends FeatureInput> FeatureCalculationCache<V> useSessionFromSource(ChildCacheName childName, V input, CacheCreator factory) throws FeatureCalculationException {
        for (CacheTransferSource<? extends FeatureInput> src : this.source) {
            if (!src.containsChild(childName)) continue;
            try {
                Optional<FeatureCalculationInput<? extends FeatureInput>> opt = src.getInputIfPresent(input);
                if (!opt.isPresent()) continue;
                return opt.get().getCache();
            }
            catch (OperationFailedException e) {
                throw new FeatureCalculationException((Throwable)e);
            }
        }
        try {
            return this.useFallbackCache(input, factory);
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private <V extends FeatureInput> FeatureCalculationCache<V> useFallbackCache(V input, CacheCreator factory) throws OperationFailedException {
        if (this.fallbackCache == null) {
            this.fallbackCache = new CacheAndReuseStrategy(factory);
        }
        return this.fallbackCache.createOrReuse(input).getCache();
    }

    @Override
    public ChildCacheFinder finderForGrandchild() {
        return DefaultChildCacheFinder.instance();
    }

    @Override
    public Optional<Set<ChildCacheName>> cachesToAvoidInvalidating() {
        return Optional.of(this.source.getAllCacheNames());
    }

    public CheckCacheForSpecificChildren(Class<?> cacheInputType, CacheTransferSourceCollection source) {
        this.cacheInputType = cacheInputType;
        this.source = source;
    }
}

