/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.calculator;

import java.util.Optional;
import org.anchoranalysis.core.cache.LRUCache;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;

class CachedMulti<T extends FeatureInput>
implements FeatureCalculatorMulti<T> {
    private final FeatureCalculatorMulti<T> source;
    private final LRUCache<T, ResultsVector> cacheResults;
    private Optional<ErrorReporter> errorReporter = Optional.empty();

    public CachedMulti(FeatureCalculatorMulti<T> source, int cacheSize) {
        this.source = source;
        this.cacheResults = new LRUCache(cacheSize, this::calculateInsideCache);
    }

    public ResultsVector calculateSuppressErrors(T input, ErrorReporter errorReporter) {
        this.errorReporter = Optional.of(errorReporter);
        try {
            return (ResultsVector)this.cacheResults.get(input);
        }
        catch (GetOperationFailedException e) {
            errorReporter.recordError(CachedMulti.class, e.getCause());
            return this.createNaNVector(e);
        }
    }

    public ResultsVector calculate(T input) throws NamedFeatureCalculateException {
        this.errorReporter = Optional.empty();
        try {
            return (ResultsVector)this.cacheResults.get(input);
        }
        catch (GetOperationFailedException e) {
            throw new NamedFeatureCalculateException(e.getKey(), e.getMessage());
        }
    }

    public ResultsVector calculate(T input, FeatureList<T> featuresSubset) throws NamedFeatureCalculateException {
        throw new NamedFeatureCalculateException("This operation is not supported for subsets of features");
    }

    public int sizeFeatures() {
        return this.source.sizeFeatures();
    }

    public boolean has(T input) {
        return this.cacheResults.has(input);
    }

    public long sizeCurrentLoad() {
        return this.cacheResults.sizeCurrentLoad();
    }

    private ResultsVector createNaNVector(GetOperationFailedException e) {
        ResultsVector results = new ResultsVector(this.source.sizeFeatures());
        results.setErrorAll((Exception)((Object)e));
        return results;
    }

    private ResultsVector calculateInsideCache(T index) throws NamedFeatureCalculateException {
        if (this.errorReporter.isPresent()) {
            return this.source.calculateSuppressErrors(index, this.errorReporter.get());
        }
        return this.source.calculate(index);
    }
}

