/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.calculator;

import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.calculator.CachedMulti;
import org.anchoranalysis.feature.session.calculator.MultiFromSingle;

class CachedSingle<T extends FeatureInput>
implements FeatureCalculatorSingle<T> {
    private final CachedMulti<T> delegate;

    public CachedSingle(FeatureCalculatorSingle<T> source, int cacheSize) {
        this.delegate = new CachedMulti<T>(new MultiFromSingle<T>(source), cacheSize);
    }

    public double calculate(T input) throws FeatureCalculationException {
        try {
            return this.delegate.calculate(input).get(0);
        }
        catch (NamedFeatureCalculateException e) {
            throw e.dropKey();
        }
    }

    public double calculateSuppressErrors(T input, ErrorReporter errorReporter) {
        return this.delegate.calculateSuppressErrors(input, errorReporter).get(0);
    }
}

