/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.calculator;

import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.calculator.CachedMulti;
import org.anchoranalysis.feature.session.calculator.CachedSingle;

public class FeatureCalculatorCache {
    private static final int DEFAULT_CACHE_SIZE = 1000;

    public static <T extends FeatureInput> FeatureCalculatorSingle<T> cache(FeatureCalculatorSingle<T> calculator) {
        return new CachedSingle<T>(calculator, 1000);
    }

    public static <T extends FeatureInput> FeatureCalculatorSingle<T> cache(FeatureCalculatorSingle<T> calculator, int cacheSize) {
        return new CachedSingle<T>(calculator, cacheSize);
    }

    public static <T extends FeatureInput> FeatureCalculatorMulti<T> cache(FeatureCalculatorMulti<T> calculator) {
        return new CachedMulti<T>(calculator, 1000);
    }

    public static <T extends FeatureInput> FeatureCalculatorMulti<T> cache(FeatureCalculatorMulti<T> calculator, int cacheSize) {
        return new CachedMulti<T>(calculator, cacheSize);
    }

    private FeatureCalculatorCache() {
    }
}

