/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.replace;

import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.cache.HorizontalCacheCreator;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;
import org.anchoranalysis.feature.shared.SharedFeatures;

public class BoundReplaceStrategy<T extends FeatureInput, S extends ReplaceStrategy<T>> {
    private final Function<CacheCreator, S> createStrategy;
    private Optional<S> strategy = Optional.empty();

    public ReplaceStrategy<T> createOrReuse(FeatureList<T> features, FeatureInitialization initialization, SharedFeatures sharedFeatures, Logger logger) {
        if (!this.strategy.isPresent()) {
            HorizontalCacheCreator cacheCreator = new HorizontalCacheCreator(features, sharedFeatures, initialization, logger);
            this.strategy = Optional.of((ReplaceStrategy)this.createStrategy.apply(cacheCreator));
        }
        return (ReplaceStrategy)this.strategy.get();
    }

    public BoundReplaceStrategy(Function<CacheCreator, S> createStrategy) {
        this.createStrategy = createStrategy;
    }

    public Optional<S> getStrategy() {
        return this.strategy;
    }
}

