/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.replace;

import org.anchoranalysis.core.cache.LRUCache;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.replace.AlwaysNew;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;

public class CacheAndReuseStrategy<T extends FeatureInput>
implements ReplaceStrategy<T> {
    private static final int CACHE_SIZE = 200;
    private LRUCache<T, FeatureCalculationInput<T>> cache;

    public CacheAndReuseStrategy(CacheCreator cacheCreator) {
        AlwaysNew delegate = new AlwaysNew(cacheCreator);
        this.cache = new LRUCache(200, delegate::createOrReuse);
    }

    @Override
    public FeatureCalculationInput<T> createOrReuse(T input) throws OperationFailedException {
        try {
            return (FeatureCalculationInput)this.cache.get(input);
        }
        catch (GetOperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public LRUCache<T, FeatureCalculationInput<T>> getCache() {
        return this.cache;
    }
}

