/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.session.replace;

import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.CacheCreator;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.SessionInputSequential;
import org.anchoranalysis.feature.session.cache.finder.ChildCacheFinder;
import org.anchoranalysis.feature.session.cache.finder.DefaultChildCacheFinder;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;

public class ReuseSingletonStrategy<T extends FeatureInput>
implements ReplaceStrategy<T> {
    private Optional<SessionInputSequential<T>> sessionInput = Optional.empty();
    private Function<T, SessionInputSequential<T>> createSessionInput = input -> new SessionInputSequential<FeatureInput>((FeatureInput)input, cacheCreator, findChildStrategy);

    public ReuseSingletonStrategy(CacheCreator cacheCreator) {
        this(cacheCreator, DefaultChildCacheFinder.instance());
    }

    public ReuseSingletonStrategy(CacheCreator cacheCreator, ChildCacheFinder findChildStrategy) {
    }

    @Override
    public FeatureCalculationInput<T> createOrReuse(T input) throws OperationFailedException {
        if (input == null) {
            throw new OperationFailedException("The input may not be null");
        }
        if (this.sessionInput.isPresent()) {
            this.sessionInput.get().replaceInput(input);
        } else {
            this.sessionInput = Optional.of(this.createSessionInput.apply(input));
        }
        return this.sessionInput.get();
    }
}

