/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.bean;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.bean.FeatureAssigner;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;

public abstract class Feature<T extends FeatureInput>
extends InitializableBean<Feature<T>, FeatureInitialization> {
    @BeanField
    @AllowEmpty
    private String customName = "";

    protected Feature() {
        super(new BeanInitializer(FeatureInitialization.class), new FeatureAssigner());
    }

    protected Feature(BeanInitializer<FeatureInitialization> propertyInitializer) {
        super(propertyInitializer, new FeatureAssigner());
    }

    public void onInitialization(FeatureInitialization initialization) throws InitializeException {
        super.onInitialization((BeanInitialization)initialization);
        this.beforeCalc(initialization);
    }

    public abstract Class<? extends FeatureInput> inputType();

    public final String describeBean() {
        String paramDscr = this.describeParameters();
        if (!paramDscr.isEmpty()) {
            return String.format("%s(%s)", this.getBeanName(), paramDscr);
        }
        return this.getBeanName();
    }

    public String descriptionLong() {
        return this.describeBean();
    }

    public Feature<T> duplicateChangeName(String customName) {
        Preconditions.checkNotNull((Object)customName);
        Feature duplicated = (Feature)((Object)this.duplicateBean());
        duplicated.setCustomName(customName);
        return duplicated;
    }

    public String getFriendlyName() {
        if (!this.getCustomName().isEmpty()) {
            return this.getCustomName();
        }
        return this.descriptionLong();
    }

    public final FeatureList<FeatureInput> createListChildFeatures() throws BeanMisconfiguredException {
        return FeatureListFactory.wrapReuse(this.findFieldsOfClass(Feature.class));
    }

    public String describeParameters() {
        return this.describeChildren();
    }

    public String toString() {
        return this.getFriendlyName();
    }

    public <S extends T> Feature<S> castAs() {
        return this;
    }

    public double calculateCheckInitialized(FeatureCalculationInput<T> input) throws FeatureCalculationException {
        if (!this.isInitialized()) {
            throw new FeatureCalculationException(String.format("The feature (%s) has not been initialized", this.toString()));
        }
        return this.calculate(input);
    }

    protected void beforeCalc(FeatureInitialization initialization) throws InitializeException {
    }

    protected abstract double calculate(FeatureCalculationInput<T> var1) throws FeatureCalculationException;

    protected void assignTo(Feature<FeatureInput> target) {
        target.customName = this.customName;
    }

    @Generated
    public String getCustomName() {
        return this.customName;
    }

    @Generated
    public void setCustomName(String customName) {
        this.customName = customName;
    }
}

