/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.bean.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.name.FeatureNameList;

public class FeatureList<T extends FeatureInput>
extends AnchorBean<FeatureList<T>>
implements Iterable<Feature<T>> {
    @BeanField
    private List<Feature<T>> list;

    public FeatureList() {
        this(new ArrayList<Feature<T>>());
    }

    public FeatureList(int capacity) {
        this(new ArrayList<Feature<T>>(capacity));
    }

    public FeatureList(Feature<T> feature) {
        this(Stream.of(feature));
    }

    public FeatureList(Stream<Feature<T>> stream) {
        this.list = stream.toList();
    }

    public FeatureList(List<Feature<T>> list) {
        this.list = list;
    }

    public void initializeRecursive(FeatureInitialization initialization, Logger logger) throws InitializeException {
        for (Feature<T> feature : this.list) {
            feature.initializeRecursive(initialization, logger);
        }
    }

    public <S extends FeatureInput, E extends Exception> FeatureList<S> map(CheckedFunction<Feature<T>, Feature<S>, E> mapFunc) throws E {
        FeatureList<T> out = new FeatureList<T>(this.list.size());
        for (Feature<T> feature : this.list) {
            out.add((Feature)((Object)mapFunc.apply(feature)));
        }
        return out;
    }

    public <S extends FeatureInput, E extends Exception> FeatureList<S> filterAndMap(Predicate<Feature<T>> predicate, CheckedFunction<Feature<T>, Feature<S>, E> mappingFunction) throws E {
        FeatureList<T> out = new FeatureList<T>();
        for (Feature<T> feature : this.list) {
            if (!predicate.test(feature)) continue;
            out.add((Feature)((Object)mappingFunction.apply(feature)));
        }
        return out;
    }

    public FeatureList<T> append(Optional<FeatureList<T>> featureList) {
        FeatureList<T> out = new FeatureList<T>();
        out.addAll(this);
        featureList.ifPresent(out::addAll);
        return out;
    }

    public FeatureNameList deriveNames() {
        return new FeatureNameList(this.list.stream().map(Feature::getFriendlyName));
    }

    public FeatureList<T> sort(Comparator<Feature<T>> comparator) {
        FeatureList<T> out = this.shallowDuplicate();
        Collections.sort(out.asList(), comparator);
        return out;
    }

    public FeatureList<T> shallowDuplicate() {
        return new FeatureList<T>(this.list.stream());
    }

    public void add(Feature<? extends T> feature) {
        this.list.add(feature);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Feature<T>> iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public List<Feature<T>> asList() {
        return this.list;
    }

    public String describeBean() {
        return String.format("%s with %d items", super.describeBean(), this.list.size());
    }

    public Feature<T> get(int index) {
        return this.list.get(index);
    }

    public void clear() {
        this.list.clear();
    }

    public void addAll(FeatureList<? extends T> toAdd) {
        for (Feature<T> feature : toAdd) {
            this.add(feature);
        }
    }

    @Generated
    public List<Feature<T>> getList() {
        return this.list;
    }

    @Generated
    public void setList(List<Feature<T>> list) {
        this.list = list;
    }
}

