/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.bean.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.functional.checked.CheckedIntFunction;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.provider.FeatureProvider;
import org.anchoranalysis.feature.input.FeatureInput;

public class FeatureListFactory {
    public static <T extends FeatureInput> FeatureList<T> empty() {
        return new FeatureList();
    }

    @SafeVarargs
    public static <T extends FeatureInput> FeatureList<T> from(Feature<T> ... feature) {
        return new FeatureList<T>(Arrays.stream(feature));
    }

    public static <T extends FeatureInput> FeatureList<T> fromProvider(Provider<Feature<T>> featureProvider) throws ProvisionFailedException {
        return FeatureListFactory.from((Feature)((Object)featureProvider.get()));
    }

    public static <T extends FeatureInput> FeatureList<T> fromIterable(Iterable<Feature<T>> iterable) {
        return new FeatureList<T>(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static <T extends FeatureInput> FeatureList<T> fromStream(Stream<Feature<T>> stream) {
        return new FeatureList<T>(stream);
    }

    public static <T extends FeatureInput> FeatureList<T> fromProviders(Collection<FeatureProvider<T>> providers) throws ProvisionFailedException {
        return new FeatureList(CheckedStream.map(providers.stream(), ProvisionFailedException.class, Provider::get));
    }

    public static <T extends FeatureInput> FeatureList<T> wrapReuse(List<Feature<T>> list) {
        return new FeatureList<T>(list);
    }

    public static <T extends FeatureInput> FeatureList<T> wrapDuplicate(List<Feature<T>> list) {
        return new FeatureList(list.stream());
    }

    public static <S, T extends FeatureInput, E extends Exception> FeatureList<T> mapFrom(Iterable<S> iterable, CheckedFunction<S, Feature<T>, E> mapFunc) throws E {
        FeatureList out = new FeatureList();
        for (S item : iterable) {
            out.add((Feature)((Object)mapFunc.apply(item)));
        }
        return out;
    }

    public static <S, T extends FeatureInput, E extends Exception> FeatureList<T> mapFromFiltered(Iterable<S> iterable, Predicate<S> predicate, CheckedFunction<S, Feature<T>, E> mapFunc) throws E {
        FeatureList out = new FeatureList();
        for (S item : iterable) {
            if (!predicate.test(item)) continue;
            out.add((Feature)((Object)mapFunc.apply(item)));
        }
        return out;
    }

    public static <S, T extends FeatureInput, E extends Exception> FeatureList<T> flatMapFromOptional(Iterable<S> iterable, CheckedFunction<S, Optional<FeatureList<T>>, E> flatMapFunc) throws E {
        FeatureList out = new FeatureList();
        for (S item : iterable) {
            ((Optional)flatMapFunc.apply(item)).ifPresent(out::addAll);
        }
        return out;
    }

    public static <T extends FeatureInput> FeatureList<T> mapFromRange(int startInclusive, int endExclusive, IntFunction<Feature<T>> mapFunc) {
        return new FeatureList<T>(IntStream.range(startInclusive, endExclusive).mapToObj(mapFunc));
    }

    public static <T extends FeatureInput, E extends Exception> FeatureList<T> mapFromRangeOptional(int startInclusive, int endExclusive, Class<? extends Exception> throwableClass, CheckedIntFunction<Optional<Feature<T>>, E> mapFunc) throws E {
        FeatureList out = new FeatureList();
        CheckedStream.mapIntStream((IntStream)IntStream.range(startInclusive, endExclusive), throwableClass, mapFunc).forEach(opt -> opt.ifPresent(out::add));
        return out;
    }

    @Generated
    private FeatureListFactory() {
    }
}

