/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.bean.operator;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.operator.FeatureFromList;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.input.FeatureInput;

public class Sum<T extends FeatureInput>
extends FeatureFromList<T> {
    @BeanField
    private boolean ignoreNaN;

    public Sum(FeatureList<T> features) {
        super(features);
    }

    @Override
    public double calculate(FeatureCalculationInput<T> input) throws FeatureCalculationException {
        double result = 0.0;
        for (Feature elem : this.getList()) {
            double resultInd = input.calculate(elem);
            if (this.ignoreNaN && Double.isNaN(resultInd)) continue;
            result += resultInd;
        }
        return result;
    }

    @Override
    public String descriptionLong() {
        return this.descriptionForList("+");
    }

    @Generated
    public Sum() {
    }

    @Generated
    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    @Generated
    public void setIgnoreNaN(boolean ignoreNaN) {
        this.ignoreNaN = ignoreNaN;
    }
}

