/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.bean.results;

import cern.colt.list.DoubleArrayList;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.feature.bean.results.FeatureResults;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.results.ResultsVectorList;

public abstract class FeatureResultsStatistic
extends FeatureResults {
    @BeanField
    private String id = "";

    @Override
    public double calculate(FeatureInputResults input) throws FeatureCalculationException {
        try {
            int index = input.getFeatureNameIndex().indexOf(this.id);
            ResultsVectorList results = input.getResults();
            if (results.isEmpty()) {
                throw new FeatureCalculationException("No feature-values exist, so this operation is undefined");
            }
            return this.statisticFromFeatureValue(FeatureResultsStatistic.extractResultsForFeature(results, index));
        }
        catch (GetOperationFailedException e) {
            throw new FeatureCalculationException(e);
        }
    }

    protected abstract double statisticFromFeatureValue(DoubleArrayList var1) throws FeatureCalculationException;

    private static DoubleArrayList extractResultsForFeature(ResultsVectorList results, int index) {
        DoubleArrayList featureValues = new DoubleArrayList();
        results.stream().forEach(resultSingle -> featureValues.add(resultSingle.get(index)));
        return featureValues;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

