/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.calculate;

import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.cache.FeatureSymbolCalculator;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;

public interface FeatureCalculator<T extends FeatureInput>
extends CalculationPartResolver<T>,
FeatureSymbolCalculator<T> {
    public double calculate(Feature<T> var1, FeatureCalculationInput<T> var2) throws FeatureCalculationException;

    default public ResultsVector calculate(FeatureList<T> features, FeatureCalculationInput<T> input) throws NamedFeatureCalculateException {
        ResultsVector out = new ResultsVector(features.size());
        for (int index = 0; index < features.size(); ++index) {
            Feature<T> feature = features.get(index);
            try {
                double val = this.calculate(feature, input);
                out.set(index, val);
                continue;
            }
            catch (FeatureCalculationException e) {
                throw new NamedFeatureCalculateException(feature.getFriendlyName(), e.getMessage());
            }
        }
        return out;
    }
}

