/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.calculate.bound;

import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;

public class FeatureCalculatorSingleFromMulti<T extends FeatureInput>
implements FeatureCalculatorSingle<T> {
    private FeatureCalculatorMulti<T> delegate;

    public FeatureCalculatorSingleFromMulti(FeatureCalculatorMulti<T> multi) throws InitializeException {
        this.delegate = multi;
        if (this.delegate.sizeFeatures() != 1) {
            throw new InitializeException(String.format("When creating a %s, the multi must have exactly one feature", FeatureCalculatorSingle.class.getSimpleName()));
        }
    }

    @Override
    public double calculateSuppressErrors(T input, ErrorReporter errorReporter) {
        return this.delegate.calculateSuppressErrors(input, errorReporter).get(0);
    }

    @Override
    public double calculate(T input) throws FeatureCalculationException {
        try {
            return this.delegate.calculate(input).get(0);
        }
        catch (NamedFeatureCalculateException e) {
            throw e.dropKey();
        }
    }
}

