/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.calculate.part;

import org.anchoranalysis.core.cache.CachedSupplier;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.cache.ResettableCalculation;
import org.anchoranalysis.feature.input.FeatureInput;

public abstract class CalculationPart<S, T extends FeatureInput>
implements ResettableCalculation {
    private T input;
    private CachedSupplier<S, FeatureCalculationException> delegate = CachedSupplier.cacheChecked(() -> this.execute(this.input));

    public synchronized S getOrCalculate(T input) throws FeatureCalculationException {
        this.assignInitialization(input);
        return (S)this.delegate.get();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean hasCachedResult() {
        return this.delegate.isEvaluated();
    }

    @Override
    public synchronized void invalidate() {
        this.delegate.reset();
        this.input = null;
    }

    protected abstract S execute(T var1) throws FeatureCalculationException;

    private synchronized void assignInitialization(T input) {
        this.input = input;
    }

    private boolean checkParametersMatchesInput(T input) {
        if (this.hasCachedResult() && input != null && !input.equals(this.input)) {
            throw new AnchorFriendlyRuntimeException("This feature already has been used, its cache is already set to a different input.");
        }
        return true;
    }
}

