/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.calculate.part;

import java.util.HashMap;
import java.util.Map;
import org.anchoranalysis.feature.calculate.cache.ResettableCalculation;
import org.anchoranalysis.feature.input.FeatureInput;

public abstract class CalculationPartMap<S, T extends FeatureInput, U, E extends Exception>
implements ResettableCalculation {
    private Map<U, S> cache = new HashMap<U, S>();

    protected CalculationPartMap(int cacheSize) {
    }

    public S getOrCalculate(T input, U key) throws E {
        S obj = this.cache.get(key);
        if (obj == null) {
            obj = this.execute(input, key);
            this.put(key, obj);
        }
        return obj;
    }

    public int numberItemsCurrentlyStored() {
        return this.cache.size();
    }

    @Override
    public void invalidate() {
        this.cache.clear();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected S getOrNull(U key) {
        return this.cache.get(key);
    }

    protected boolean hasKey(U key) {
        return this.cache.get(key) != null;
    }

    protected void put(U key, S result) {
        this.cache.put(key, result);
    }

    protected abstract S execute(T var1, U var2) throws E;
}

