/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.energy;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.spatial.box.Extent;

public class EnergyStack {
    private final EnergyStackWithoutParameters delegate;
    private Dictionary parameters;

    public EnergyStack(Channel channel) {
        this(new EnergyStackWithoutParameters(channel));
    }

    public EnergyStack(EnergyStackWithoutParameters energyStack) {
        this(energyStack, new Dictionary());
    }

    public EnergyStack(Stack stack, Dictionary dictionary) {
        this(new EnergyStackWithoutParameters(stack), dictionary);
    }

    public EnergyStack(Stack stack) {
        this(new EnergyStackWithoutParameters(stack));
    }

    public EnergyStack(Dimensions dimensions) {
        this(new EnergyStackWithoutParameters(dimensions));
    }

    public EnergyStack extractSlice(int z) throws OperationFailedException {
        return new EnergyStack(this.delegate.extractSlice(z), this.parameters);
    }

    public boolean hasOneSlice() {
        return this.dimensions().extent().z() == 1;
    }

    public Dimensions dimensions() {
        return this.delegate.dimensions();
    }

    public Optional<Resolution> resolution() {
        return this.dimensions().resolution();
    }

    public EnergyStack copyChangeDictionary(Dictionary dictionaryToAssign) {
        return new EnergyStack(this.delegate, dictionaryToAssign);
    }

    public Channel getChannel(int index) {
        return this.delegate.getChannel(index);
    }

    public Stack asStack() {
        return this.delegate.asStack();
    }

    public Extent extent() {
        return this.delegate.extent();
    }

    public EnergyStackWithoutParameters withoutParameters() {
        return this.delegate;
    }

    public final int getNumberChannels() {
        return this.delegate.getNumberChannels();
    }

    @Generated
    public EnergyStack(EnergyStackWithoutParameters delegate, Dictionary parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Generated
    public Dictionary getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(Dictionary parameters) {
        this.parameters = parameters;
    }
}

