/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.energy;

import com.google.common.base.Functions;
import io.vavr.control.Either;
import java.util.function.Function;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.OperationFailedRuntimeException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.spatial.box.Extent;

public class EnergyStackWithoutParameters {
    private final Either<Dimensions, Stack> container;

    public EnergyStackWithoutParameters(Channel channel) {
        this.container = Either.right((Object)new Stack(channel));
    }

    public EnergyStackWithoutParameters(Stack stack) {
        this.container = Either.right((Object)stack);
    }

    public EnergyStackWithoutParameters(Dimensions dimensions) {
        this.container = Either.left((Object)dimensions);
    }

    public final int getNumberChannels() {
        return (Integer)this.container.map(Stack::getNumberChannels).getOrElseGet(dimensions -> 0);
    }

    public Dimensions dimensions() {
        return (Dimensions)this.container.map(Stack::dimensions).getOrElseGet((Function)Functions.identity());
    }

    public Extent extent() {
        return this.dimensions().extent();
    }

    public final Channel getChannel(int index) {
        if (this.container.isLeft()) {
            this.throwInvalidIndexException(0, index);
        }
        if (index >= ((Stack)this.container.get()).getNumberChannels()) {
            this.throwInvalidIndexException(((Stack)this.container.get()).getNumberChannels(), index);
        }
        return ((Stack)this.container.get()).getChannel(index);
    }

    public Stack asStack() {
        return (Stack)this.container.getOrElse(Stack::new);
    }

    public EnergyStackWithoutParameters extractSlice(int z) throws OperationFailedException {
        if (this.container.isLeft()) {
            throw new OperationFailedException("No slice can be extracted, as no channels existing in the energy-stack");
        }
        return new EnergyStackWithoutParameters(((Stack)this.container.get()).extractSlice(z));
    }

    private void throwInvalidIndexException(int numberChannels, int index) {
        throw new OperationFailedRuntimeException(String.format("There are %d channels in the energy-stack. Cannot access index %d.", numberChannels, index));
    }
}

