/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.initialization;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;

public final class FeatureInitialization
implements BeanInitialization {
    private final Optional<Dictionary> dictionary;
    private final Optional<EnergyStackWithoutParameters> energyStack;
    private final Optional<SharedObjects> sharedObjects;

    public FeatureInitialization() {
        this.dictionary = Optional.empty();
        this.energyStack = Optional.empty();
        this.sharedObjects = Optional.empty();
    }

    public FeatureInitialization(SharedObjects sharedObjects) {
        this.dictionary = Optional.empty();
        this.energyStack = Optional.empty();
        this.sharedObjects = Optional.of(sharedObjects);
    }

    public FeatureInitialization(Dictionary dictionary) {
        this.dictionary = Optional.of(dictionary);
        this.energyStack = Optional.empty();
        this.sharedObjects = Optional.empty();
    }

    public FeatureInitialization(EnergyStack energyStack) {
        this.energyStack = Optional.of(energyStack.withoutParameters());
        this.dictionary = Optional.of(energyStack.getParameters());
        this.sharedObjects = Optional.empty();
    }

    public FeatureInitialization duplicateShallow() {
        return new FeatureInitialization(this.dictionary, this.energyStack, this.sharedObjects);
    }

    public SharedObjects sharedObjectsRequired() throws InitializeException {
        return this.sharedObjects.orElseThrow(() -> new InitializeException("Shared-objects are required for this bean, but are not available."));
    }

    @Generated
    public Optional<Dictionary> getDictionary() {
        return this.dictionary;
    }

    @Generated
    public Optional<EnergyStackWithoutParameters> getEnergyStack() {
        return this.energyStack;
    }

    @Generated
    public Optional<SharedObjects> getSharedObjects() {
        return this.sharedObjects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureInitialization)) {
            return false;
        }
        FeatureInitialization other = (FeatureInitialization)o;
        Optional<Dictionary> this$dictionary = this.getDictionary();
        Optional<Dictionary> other$dictionary = other.getDictionary();
        if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
            return false;
        }
        Optional<EnergyStackWithoutParameters> this$energyStack = this.getEnergyStack();
        Optional<EnergyStackWithoutParameters> other$energyStack = other.getEnergyStack();
        if (this$energyStack == null ? other$energyStack != null : !((Object)this$energyStack).equals(other$energyStack)) {
            return false;
        }
        Optional<SharedObjects> this$sharedObjects = this.getSharedObjects();
        Optional<SharedObjects> other$sharedObjects = other.getSharedObjects();
        return !(this$sharedObjects == null ? other$sharedObjects != null : !((Object)this$sharedObjects).equals(other$sharedObjects));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Dictionary> $dictionary = this.getDictionary();
        result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
        Optional<EnergyStackWithoutParameters> $energyStack = this.getEnergyStack();
        result = result * 59 + ($energyStack == null ? 43 : ((Object)$energyStack).hashCode());
        Optional<SharedObjects> $sharedObjects = this.getSharedObjects();
        result = result * 59 + ($sharedObjects == null ? 43 : ((Object)$sharedObjects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FeatureInitialization(dictionary=" + String.valueOf(this.getDictionary()) + ", energyStack=" + String.valueOf(this.getEnergyStack()) + ", sharedObjects=" + String.valueOf(this.getSharedObjects()) + ")";
    }

    @Generated
    public FeatureInitialization(Optional<Dictionary> dictionary, Optional<EnergyStackWithoutParameters> energyStack, Optional<SharedObjects> sharedObjects) {
        this.dictionary = dictionary;
        this.energyStack = energyStack;
        this.sharedObjects = sharedObjects;
    }
}

