/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.initialization;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.shared.dictionary.DictionaryInitialization;
import org.anchoranalysis.bean.shared.path.FilePathInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.CommonContext;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.shared.SharedFeatures;

public class FeatureRelatedInitialization
implements BeanInitialization {
    private DictionaryInitialization dictionary;
    private FilePathInitialization filePaths;
    private SharedFeatures sharedFeatures;
    private NamedProviderStore<FeatureList<FeatureInput>> featuresStore;

    private FeatureRelatedInitialization(SharedObjects sharedObjects) {
        this.dictionary = new DictionaryInitialization(sharedObjects);
        this.filePaths = new FilePathInitialization(sharedObjects);
        this.featuresStore = sharedObjects.getOrCreate(FeatureList.class);
        this.sharedFeatures = new SharedFeatures();
        this.sharedFeatures.addFromProviders((NamedProvider<FeatureList<FeatureInput>>)this.featuresStore);
    }

    public static FeatureRelatedInitialization create(SharedObjects sharedObjects) {
        return new FeatureRelatedInitialization(sharedObjects);
    }

    public static FeatureRelatedInitialization create(Logger logger, Path modelDirectory) {
        return FeatureRelatedInitialization.create(new SharedObjects(new CommonContext(logger, modelDirectory)));
    }

    public NamedProviderStore<FeatureList<FeatureInput>> getFeatureLists() {
        return this.featuresStore;
    }

    public void populate(List<NamedBean<FeatureListProvider<FeatureInput>>> namedProviders, Logger logger) throws OperationFailedException {
        Preconditions.checkArgument((this.getFeatureLists() != null ? 1 : 0) != 0);
        try {
            for (NamedBean<FeatureListProvider<FeatureInput>> namedBean : namedProviders) {
                ((FeatureListProvider)namedBean.getItem()).initializeRecursive(this, logger);
                this.addFeatureList(namedBean);
            }
        }
        catch (InitializeException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void addFeatureList(NamedBean<FeatureListProvider<FeatureInput>> provider) throws OperationFailedException {
        try {
            FeatureList featureList = (FeatureList)((FeatureListProvider)provider.getItem()).get();
            String name = provider.getName();
            if (featureList.size() == 1) {
                featureList.get(0).setCustomName(name);
            }
            this.featuresStore.add(name, () -> featureList);
            this.sharedFeatures.addFromList(featureList);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Generated
    public DictionaryInitialization getDictionary() {
        return this.dictionary;
    }

    @Generated
    public FilePathInitialization getFilePaths() {
        return this.filePaths;
    }

    @Generated
    public SharedFeatures getSharedFeatures() {
        return this.sharedFeatures;
    }
}

