/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.input;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInputDictionary;
import org.anchoranalysis.feature.input.FeatureInputDimensions;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.UnitConverter;

public abstract class FeatureInputEnergy
extends FeatureInputDimensions
implements FeatureInputDictionary {
    private Optional<EnergyStack> energyStack;

    protected FeatureInputEnergy() {
        this(Optional.empty());
    }

    public Optional<UnitConverter> getUnitConverterOptional() {
        return this.getResolutionOptional().map(Resolution::unitConvert);
    }

    @Override
    public Optional<Resolution> getResolutionOptional() {
        return this.energyStack.map(EnergyStack::dimensions).flatMap(Dimensions::resolution);
    }

    @Override
    public Optional<Dictionary> getDictionaryOptional() {
        return this.energyStack.map(EnergyStack::getParameters);
    }

    @Override
    public Dimensions dimensions() throws FeatureCalculationException {
        return this.dimensionsRequired();
    }

    public Dimensions dimensionsRequired() throws FeatureCalculationException {
        return this.dimensionsOptional().orElseThrow(() -> new FeatureCalculationException("Dimensions are required in the input for this operation"));
    }

    public Optional<Dimensions> dimensionsOptional() {
        return this.energyStack.map(EnergyStack::dimensions);
    }

    public EnergyStack getEnergyStackRequired() throws FeatureCalculationException {
        return this.energyStack.orElseThrow(() -> new FeatureCalculationException("An energy-stack is required in the input for this operation"));
    }

    public Optional<EnergyStack> getEnergyStackOptional() {
        return this.energyStack;
    }

    public void setEnergyStack(EnergyStack energyStack) {
        this.energyStack = Optional.of(energyStack);
    }

    public void setEnergyStack(Optional<EnergyStack> energyStack) {
        this.energyStack = energyStack;
    }

    @Generated
    public FeatureInputEnergy(Optional<EnergyStack> energyStack) {
        this.energyStack = energyStack;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureInputEnergy)) {
            return false;
        }
        FeatureInputEnergy other = (FeatureInputEnergy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Optional<EnergyStack> this$energyStack = this.energyStack;
        Optional<EnergyStack> other$energyStack = other.energyStack;
        return !(this$energyStack == null ? other$energyStack != null : !((Object)this$energyStack).equals(other$energyStack));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureInputEnergy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Optional<EnergyStack> $energyStack = this.energyStack;
        result = result * 59 + ($energyStack == null ? 43 : ((Object)$energyStack).hashCode());
        return result;
    }
}

