/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.input;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.input.FeatureInput;

public class FeatureInputType {
    public static boolean isCompatibleWith(Class<? extends FeatureInput> sourceType, Class<? extends FeatureInput> otherType) {
        return sourceType.isAssignableFrom(otherType);
    }

    public static Optional<Class<? extends FeatureInput>> prefer(Class<? extends FeatureInput> inputType1, Class<? extends FeatureInput> inputType2) {
        if (inputType1.equals(inputType2)) {
            return Optional.of(inputType1);
        }
        if (FeatureInputType.isCompatibleWith(inputType1, inputType2)) {
            return Optional.of(inputType2);
        }
        if (FeatureInputType.isCompatibleWith(inputType2, inputType1)) {
            return Optional.of(inputType1);
        }
        return Optional.empty();
    }

    public static Class<? extends FeatureInput> prefer(Feature<?> feature1, Feature<?> feature2) {
        return FeatureInputType.determineInputType(feature1.inputType(), feature2.inputType());
    }

    public static Class<? extends FeatureInput> determineInputType(Class<? extends FeatureInput> inputType1, Class<? extends FeatureInput> inputType2) {
        Optional<Class<? extends FeatureInput>> preferred = FeatureInputType.prefer(inputType1, inputType2);
        if (!preferred.isPresent()) {
            throw new AnchorFriendlyRuntimeException("item1 and item2 must accept the same paramType, or be compatible.");
        }
        return preferred.get();
    }

    public static <T extends FeatureInput> Class<? extends FeatureInput> determineInputType(List<Feature<T>> list) {
        if (list.isEmpty()) {
            return FeatureInput.class;
        }
        Class<FeatureInput> chosenParamType = FeatureInput.class;
        for (Feature<T> feature : list) {
            Class<FeatureInput> paramType = feature.inputType();
            if (chosenParamType.equals(paramType)) continue;
            Optional<Class<? extends FeatureInput>> preferred = FeatureInputType.prefer(paramType, chosenParamType);
            if (!preferred.isPresent()) {
                throw new AnchorFriendlyRuntimeException("All features in the list must have the same paramType, or a simple type, or a preference between conflicting type");
            }
            chosenParamType = preferred.get();
        }
        return chosenParamType;
    }

    @Generated
    private FeatureInputType() {
    }
}

