/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.name;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalIterate;
import org.anchoranalysis.feature.name.FeatureNameMapToIndex;

public class FeatureNameList
implements Iterable<String> {
    private List<String> list;

    public FeatureNameList() {
        this.list = new ArrayList<String>();
    }

    public FeatureNameList(Stream<String> stream) {
        this.list = stream.collect(Collectors.toCollection(ArrayList::new));
    }

    public List<String> asList() {
        return this.list;
    }

    public FeatureNameMapToIndex createMapToIndex() {
        FeatureNameMapToIndex out = new FeatureNameMapToIndex();
        for (int i = 0; i < this.list.size(); ++i) {
            out.add(this.list.get(i), i);
        }
        return out;
    }

    public FeatureNameList duplicateShallow() {
        return new FeatureNameList(this.list.stream());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.list) {
            sb.append(s);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void add(String name) {
        this.list.add(name);
    }

    public void insertBeginning(String name) {
        this.list.add(0, name);
    }

    public void insertBeginning(String[] names) {
        FunctionalIterate.reverseIterateArray((Object[])names, this::insertBeginning);
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    public String get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    @Generated
    public FeatureNameList(List<String> list) {
        this.list = list;
    }
}

