/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.results;

import java.util.Collection;
import java.util.Optional;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.results.ArrayComparer;
import org.anchoranalysis.feature.results.ArrayComparerPrecision;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ResultsVector {
    private static final ArrayComparer DEFAULT_COMPARER = new ArrayComparer();
    private Object[] vector;

    public ResultsVector(int size) {
        this.vector = new Object[size];
    }

    public double total() {
        double sum = 0.0;
        for (int i = 0; i < this.vector.length; ++i) {
            sum += this.get(i);
        }
        return sum;
    }

    public void set(int index, double value) {
        this.vector[index] = value;
    }

    public void set(int startIndex, ResultsVector resultsToAssign) {
        for (int index = 0; index < resultsToAssign.size(); ++index) {
            Object value;
            this.vector[startIndex + index] = value = resultsToAssign.vector[index];
        }
    }

    public void setError(int index, Exception exception) {
        this.vector[index] = exception;
    }

    public void setErrorAll(Exception exception) {
        for (int index = 0; index < this.vector.length; ++index) {
            this.setError(index, exception);
        }
    }

    public Exception getError(int index) {
        return (Exception)this.vector[index];
    }

    public Optional<Double> getResult(int index) {
        Object obj = this.vector[index];
        if (obj instanceof Exception) {
            return Optional.empty();
        }
        return Optional.of((Double)obj);
    }

    public double get(int index) {
        Object obj = this.vector[index];
        if (obj instanceof Exception) {
            return Double.NaN;
        }
        assert (obj instanceof Double);
        return (Double)obj;
    }

    public void copyFrom(int index, int length, ResultsVector source, int sourceIndex) {
        for (int i = 0; i < length; ++i) {
            int indexIn = sourceIndex + i;
            int indexOut = index + i;
            this.vector[indexOut] = source.vector[indexIn];
        }
    }

    public void addTypedValuesTo(Collection<TypedValue> addTo, int numberDecimalPlaces) {
        for (int index = 0; index < this.vector.length; ++index) {
            double value = this.get(index);
            TypedValue representation = numberDecimalPlaces == -1 ? new TypedValue(value) : new TypedValue(value, numberDecimalPlaces);
            addTo.add(representation);
        }
    }

    public int size() {
        return this.vector.length;
    }

    public boolean equals(Object ... values) {
        return DEFAULT_COMPARER.compareArrays(this.vector, values);
    }

    public boolean equalsPrecision(double eps, Object ... values) {
        return new ArrayComparerPrecision(eps).compareArrays(this.vector, values);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof ResultsVector)) {
            return false;
        }
        ResultsVector other = (ResultsVector)obj;
        return DEFAULT_COMPARER.compareArrays(this.vector, other.vector);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.vector).toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < this.vector.length; ++index) {
            if (index != 0) {
                builder.append(", ");
            }
            builder.append(this.getString(index));
        }
        return builder.toString();
    }

    private String getString(int index) {
        Object obj = this.vector[index];
        return obj.toString();
    }
}

