/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.identifier.name.NameValue;
import org.anchoranalysis.core.identifier.name.SimpleNameValue;
import org.anchoranalysis.core.identifier.provider.NameValueMap;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputType;
import org.anchoranalysis.feature.shared.SharedFeaturesSubset;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class SharedFeatures
implements NamedProvider<Feature<FeatureInput>>,
Iterable<NameValue<Feature<FeatureInput>>> {
    private NameValueMap<Feature<FeatureInput>> mapByKey = new NameValueMap();
    private MultiMap mapByDescriptor = new MultiValueMap();
    private Set<Feature<FeatureInput>> setFeatures = new HashSet<Feature<FeatureInput>>();

    public <S extends FeatureInput> SharedFeaturesSubset<S> subsetCompatibleWith(Class<? extends FeatureInput> inputType) {
        NameValueMap out = new NameValueMap();
        for (Class descriptor : this.mapByDescriptor.keySet()) {
            if (!FeatureInputType.isCompatibleWith(descriptor, inputType)) continue;
            SharedFeatures.transferToSet((Collection)this.mapByDescriptor.get((Object)descriptor), out);
        }
        return new SharedFeaturesSubset(out);
    }

    public String toString() {
        return this.mapByKey.keys().toString();
    }

    public boolean contains(Feature<FeatureInput> feature) {
        return this.setFeatures.contains(feature);
    }

    public SharedFeatures duplicate() {
        SharedFeatures out = new SharedFeatures();
        for (NameValue nameValue : this.mapByKey) {
            out.addNoDuplicate((NameValue<Feature<FeatureInput>>)nameValue);
        }
        return out;
    }

    public void addFromProviders(NamedProvider<FeatureList<FeatureInput>> provider) {
        for (String key : provider.keys()) {
            try {
                this.addFromList((FeatureList)provider.getException(key));
            }
            catch (NamedProviderGetException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
    }

    public void addFromList(FeatureList<FeatureInput> list) {
        for (Feature<FeatureInput> feature : list) {
            this.addNoDuplicate((NameValue<Feature<FeatureInput>>)new SimpleNameValue(feature.getFriendlyName(), feature));
        }
    }

    public void removeIfExists(FeatureList<FeatureInput> featuresToRemove) {
        featuresToRemove.forEach(arg_0 -> this.mapByKey.removeIfExists(arg_0));
    }

    @Override
    public Iterator<NameValue<Feature<FeatureInput>>> iterator() {
        return this.mapByKey.iterator();
    }

    public Optional<Feature<FeatureInput>> getOptional(String key) {
        return this.mapByKey.getOptional(key);
    }

    public Set<String> keys() {
        return this.mapByKey.keys();
    }

    private void addNoDuplicate(NameValue<Feature<FeatureInput>> feature) {
        this.mapByKey.add(feature);
        this.mapByDescriptor.put(((Feature)((Object)feature.getValue())).inputType(), feature);
        this.setFeatures.add((Feature)((Object)feature.getValue()));
    }

    private static <S extends FeatureInput> void transferToSet(Collection<NameValue<Feature<S>>> in, NameValueMap<Feature<S>> out) {
        for (NameValue<Feature<S>> nv : in) {
            out.add(nv);
        }
    }
}

