/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.store;

import lombok.Generated;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.store.NamedFeatureStore;

class AddFeaturesHelper {
    public static <T extends FeatureInput> void addFeaturesToStore(FeatureList<T> featureList, String nameParent, boolean parametersOnlyInDescription, NamedFeatureStore<T> store) {
        for (Feature<T> features : featureList) {
            String chosenName = AddFeaturesHelper.determineFeatureName(features, nameParent, featureList.size() == 1, parametersOnlyInDescription);
            store.add(chosenName, (Feature)((Object)features.duplicateBean()));
        }
    }

    private static <T extends FeatureInput> String determineFeatureName(Feature<T> feature, String nameParent, boolean useOnlyParentName, boolean parametersOnlyInDescription) {
        if (useOnlyParentName) {
            return nameParent;
        }
        return String.format("%s.%s", nameParent, AddFeaturesHelper.featureDescription(feature, parametersOnlyInDescription));
    }

    private static String featureDescription(Feature<?> feature, boolean parametersOnlyInDescription) {
        if (!feature.getCustomName().isEmpty()) {
            return feature.getCustomName();
        }
        if (parametersOnlyInDescription) {
            return feature.describeParameters();
        }
        return feature.getFriendlyName();
    }

    @Generated
    private AddFeaturesHelper() {
    }
}

