/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.name.FeatureNameList;

public class NamedFeatureStore<T extends FeatureInput>
implements Iterable<NamedBean<Feature<T>>> {
    private List<NamedBean<Feature<T>>> list = new ArrayList<NamedBean<Feature<T>>>();
    private Map<String, Integer> mapIndex = new HashMap<String, Integer>();

    public void add(String name, Feature<T> feature) {
        this.mapIndex.put(name, this.list.size());
        feature.setCustomName(name);
        this.list.add(new NamedBean(name, feature));
    }

    public NamedBean<Feature<T>> get(int index) {
        return this.list.get(index);
    }

    public NamedBean<Feature<T>> get(String name) {
        int index = this.mapIndex.get(name);
        return this.list.get(index);
    }

    public FeatureList<T> features() {
        return FeatureListFactory.mapFrom(this.list, NamedBean::getValue);
    }

    public FeatureNameList featureNames() {
        return new FeatureNameList(this.list.stream().map(NamedBean::getName));
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<NamedBean<Feature<T>>> iterator() {
        return this.list.iterator();
    }

    public NamedFeatureStore<T> duplicate() {
        NamedFeatureStore<T> out = new NamedFeatureStore<T>();
        for (NamedBean<Feature<T>> namedBean : this.list) {
            out.add(namedBean.getName(), (Feature)((Object)((Feature)namedBean.getValue()).duplicateBean()));
        }
        return out;
    }
}

