/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.store;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.store.AddFeaturesHelper;
import org.anchoranalysis.feature.store.NamedFeatureStore;

public class NamedFeatureStoreFactory {
    private boolean parametersOnlyInDescription = false;

    public static NamedFeatureStoreFactory parametersOnly() {
        return new NamedFeatureStoreFactory(true);
    }

    public static NamedFeatureStoreFactory bothNameAndParameters() {
        return new NamedFeatureStoreFactory(false);
    }

    public <T extends FeatureInput> NamedFeatureStore<T> createNamedFeatureList(List<NamedBean<FeatureListProvider<T>>> namedFeatures) throws ProvisionFailedException {
        NamedFeatureStore out = new NamedFeatureStore();
        for (NamedBean<FeatureListProvider<T>> namedProvider : namedFeatures) {
            try {
                FeatureList featureList = (FeatureList)((FeatureListProvider)namedProvider.getValue()).get();
                if (featureList.size() <= 0) continue;
                AddFeaturesHelper.addFeaturesToStore(featureList, namedProvider.getName(), this.parametersOnlyInDescription, out);
            }
            catch (BeanDuplicateException | ProvisionFailedException e) {
                throw new ProvisionFailedException(String.format("An error occurred creating a named-feature-list from provider '%s'", namedProvider.getName()), e);
            }
        }
        return out;
    }

    @Generated
    private NamedFeatureStoreFactory(boolean parametersOnlyInDescription) {
        this.parametersOnlyInDescription = parametersOnlyInDescription;
    }
}

