/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean.spatial.arrange;

import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class BufferPair {
    private final VoxelBuffer<?>[] source;
    private final VoxelBuffer<?>[] destination;

    public BufferPair(int numberChannels) {
        this.source = new VoxelBuffer[numberChannels];
        this.destination = new VoxelBuffer[numberChannels];
    }

    public void assign(Stack sourceStack, Stack destinationStack, int sourceZ, int destinationZ) {
        int[] sourceChannelMapping = new int[]{this.selectSourceChannel(0, sourceStack.getNumberChannels()), this.selectSourceChannel(1, sourceStack.getNumberChannels()), this.selectSourceChannel(2, sourceStack.getNumberChannels())};
        for (int channelIndex = 0; channelIndex < this.destination.length; ++channelIndex) {
            int destinationChannel = sourceChannelMapping[channelIndex];
            this.source[channelIndex] = destinationChannel != -1 ? BufferPair.bufferForSlice(sourceStack, sourceChannelMapping[channelIndex], sourceZ) : null;
            this.destination[channelIndex] = BufferPair.bufferForSlice(destinationStack, channelIndex, destinationZ);
        }
    }

    public void copySlice(ReadableTuple3i cornerMin, ReadableTuple3i cornerMax, Extent sizeDestination) {
        int index = 0;
        for (int y = cornerMin.y(); y <= cornerMax.y(); ++y) {
            for (int x = cornerMin.x(); x <= cornerMax.x(); ++x) {
                int outPos = sizeDestination.offset(x, y);
                for (int channel = 0; channel < this.destination.length; ++channel) {
                    VoxelBuffer<?> sourceBuffer = this.source[channel];
                    if (sourceBuffer == null) continue;
                    this.destination[channel].putInt(outPos, sourceBuffer.getInt(index));
                }
                ++index;
            }
        }
    }

    private int selectSourceChannel(int destinationChannelIndex, int numberChannelsSource) {
        if (destinationChannelIndex < numberChannelsSource) {
            return destinationChannelIndex;
        }
        if (numberChannelsSource == 1) {
            return 0;
        }
        return -1;
    }

    private static VoxelBuffer<?> bufferForSlice(Stack stack, int channelIndex, int sliceIndex) {
        return stack.getChannel(channelIndex).voxels().slice(sliceIndex);
    }
}

