/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange;

import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackCopierAtBox;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public abstract class StackArranger
extends AnchorBean<StackArranger> {
    public RGBStack combine(List<RGBStack> stacks, VoxelsResizer resizer, OperationContext context) throws ArrangeStackException {
        return this.combine(stacks, resizer, (ChannelFactorySingleType)ChannelFactory.instance().get((VoxelDataType)UnsignedByteVoxelType.INSTANCE), context);
    }

    public RGBStack combine(List<RGBStack> stacks, VoxelsResizer resizer, ChannelFactorySingleType factory, OperationContext context) throws ArrangeStackException {
        Iterator<Extent> extentIterator = stacks.stream().map(RGBStack::extent).iterator();
        StackArrangement arrangement = this.arrangeStacks(extentIterator, context);
        if (extentIterator.hasNext()) {
            throw new ArrangeStackException("There are more stacks than can be arranged.");
        }
        RGBStack stackOut = new RGBStack(arrangement.extent(), factory);
        StackArranger.populateStacks(stacks, arrangement, resizer, stackOut.asStack());
        return stackOut;
    }

    public abstract StackArrangement arrangeStacks(Iterator<Extent> var1, OperationContext var2) throws ArrangeStackException;

    private static void populateStacks(Iterable<RGBStack> generatedImages, StackArrangement arrangement, VoxelsResizer resizer, Stack out) throws ArrangeStackException {
        int index = 0;
        for (RGBStack image : generatedImages) {
            BoundingBox box = arrangement.get(index++).getBox();
            if (!image.extent().equals((Object)box.extent())) {
                try {
                    image = image.mapChannel(channel -> channel.resizeXY(box.extent(), resizer));
                }
                catch (OperationFailedException e) {
                    throw new ArrangeStackException("Failed to resize an image before copying", (Exception)((Object)e));
                }
            }
            StackCopierAtBox.copyImageInto(image.asStack(), out, box);
        }
    }
}

