/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.align;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.arrange.align.Align;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Grow
extends BoxAligner {
    @BeanField
    private boolean preserveAspectRatio = false;
    @BeanField
    private Align align = new Align();

    public Grow(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    @Override
    protected BoundingBox alignAfterCheck(BoundingBox smaller, BoundingBox larger) throws OperationFailedException {
        if (this.preserveAspectRatio) {
            Extent smallerGrown = this.growSmaller(smaller.extent(), larger.extent());
            return this.align.align(smallerGrown, larger);
        }
        return larger;
    }

    @Override
    protected BoundingBox alignAfterCheck(Extent smaller, Extent larger) throws OperationFailedException {
        if (this.preserveAspectRatio) {
            Extent smallerGrown = this.growSmaller(smaller, larger);
            return this.align.align(smallerGrown, larger);
        }
        return new BoundingBox(larger);
    }

    @Override
    protected BoundingBox alignAfterCheck(Extent smaller, BoundingBox larger) throws OperationFailedException {
        if (this.preserveAspectRatio) {
            Extent smallerGrown = this.growSmaller(smaller, larger.extent());
            return this.align.align(smallerGrown, larger);
        }
        return larger;
    }

    private Extent growSmaller(Extent smaller, Extent larger) {
        ScaleFactor factor = RelativeScaleCalculator.relativeScalePreserveAspectRatio((Extent)smaller, (Extent)larger);
        return smaller.scaleXYBy(factor, true);
    }

    public Grow() {
    }

    public Grow(boolean preserveAspectRatio, Align align) {
        this.preserveAspectRatio = preserveAspectRatio;
        this.align = align;
    }

    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }
}

